/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.gui.FullItemDialogGuiLayer;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.controls.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.controls.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.GuiStateButton;
import team.creative.creativecore.common.gui.controls.GuiTextfield;
import team.creative.creativecore.common.gui.controls.layout.GuiVBox;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientMaterial;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.Pair;
import team.creative.creativecore.common.util.type.PairList;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    private static PairList<String, GuiCreativeIngredientHandler> handlers = new PairList();
    public static GuiCreativeIngredientHandler defaultHandler = new GuiCreativeIngredientHandler(){

        @Override
        public void createControls(FullItemDialogGuiLayer gui, CreativeIngredient info) {
            GuiStackSelector selector = new GuiStackSelector("inv", 0, 30, 122, null, new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector()));
            gui.add(selector);
            gui.add(new GuiLabel("guilabel1", 70, 80));
            gui.add(new GuiLabel("guilabel2", 70, 90));
            GuiStateButton damage = new GuiStateButton("damage", 0, 80, 0, new TextListBuilder().add("Damage: Off", "Damage: On"));
            gui.add(damage);
            GuiStateButton nbt = new GuiStateButton("nbt", 0, 100, 0, new TextListBuilder().add("NBT: Off", "NBT: On"));
            gui.add(nbt);
            if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                selector.setSelectedForce(info.getExample().func_77946_l());
                if (info instanceof CreativeIngredientItemStack) {
                    damage.nextState();
                    if (((CreativeIngredientItemStack)info).needNBT) {
                        nbt.nextState();
                    }
                }
            }
            this.onChanged(gui, new GuiControlChangedEvent(selector));
        }

        @Override
        public boolean canHandle(CreativeIngredient info) {
            return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
        }

        @Override
        public CreativeIngredient parseInfo(FullItemDialogGuiLayer gui) {
            ItemStack stack = ((GuiStackSelector)gui.get("inv")).getSelected();
            if (stack != null) {
                boolean nbt;
                boolean damage = ((GuiStateButton)gui.get("damage")).getState() == 1;
                boolean bl = nbt = ((GuiStateButton)gui.get("nbt")).getState() == 1;
                if (damage) {
                    return new CreativeIngredientItemStack(stack.func_77946_l(), nbt);
                }
                if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof AirBlock)) {
                    return new CreativeIngredientBlock(Block.func_149634_a((Item)stack.func_77973_b()));
                }
                return new CreativeIngredientItem(stack.func_77973_b());
            }
            return null;
        }

        @Override
        public void onChanged(FullItemDialogGuiLayer gui, GuiControlChangedEvent event) {
            GuiStackSelector selector;
            if (event.control.is("inv") && (selector = (GuiStackSelector)event.control) != null) {
                ItemStack stack = selector.getSelected();
                if (!stack.func_190926_b()) {
                    ((GuiLabel)gui.get("guilabel1")).setTitle((ITextComponent)new StringTextComponent("damage: " + stack.func_77952_i()));
                    ((GuiLabel)gui.get("guilabel2")).setTitle((ITextComponent)new StringTextComponent("nbt: " + stack.func_77978_p()));
                } else {
                    ((GuiLabel)gui.get("guilabel1")).setTitle((ITextComponent)new StringTextComponent(""));
                    ((GuiLabel)gui.get("guilabel2")).setTitle((ITextComponent)new StringTextComponent(""));
                }
            }
        }
    };
    private String name;

    public static void registerGuiInfoHandler(String name, GuiCreativeIngredientHandler handler) {
        handler.name = name;
        handlers.add(name, handler);
    }

    public static int indexOf(String name) {
        return handlers.indexOfKey(name);
    }

    public static GuiCreativeIngredientHandler get(int index) {
        return (GuiCreativeIngredientHandler)((Pair)GuiCreativeIngredientHandler.handlers.get((int)index)).value;
    }

    public static Set<String> getNames() {
        return handlers.keys();
    }

    public static GuiCreativeIngredientHandler getHandler(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : handlers.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return defaultHandler;
    }

    public static GuiCreativeIngredientHandler getHandler(String name) {
        GuiCreativeIngredientHandler handler = handlers.getValue(name);
        if (handler == null) {
            return defaultHandler;
        }
        return handler;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(FullItemDialogGuiLayer var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseInfo(FullItemDialogGuiLayer var1);

    public void onChanged(FullItemDialogGuiLayer gui, GuiControlChangedEvent event) {
    }

    static {
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Default", defaultHandler);
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Material", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseInfo(FullItemDialogGuiLayer gui) {
                Block block;
                ItemStack blockStack = ((GuiStackSelector)gui.get("inv")).getSelected();
                if (blockStack != null && !((block = Block.func_149634_a((Item)blockStack.func_77973_b())) instanceof AirBlock)) {
                    return new CreativeIngredientMaterial(block.func_176223_P().func_185904_a());
                }
                return null;
            }

            @Override
            public void createControls(FullItemDialogGuiLayer gui, CreativeIngredient info) {
                GuiStackSelector selector = new GuiStackSelector("inv", 0, 30, 122, null, new GuiStackSelector.CreativeCollector(new GuiStackSelector.GuiBlockSelector()));
                gui.add(selector);
                if (info instanceof CreativeIngredientMaterial) {
                    selector.setSelectedForce(info.getExample());
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientMaterial;
            }
        });
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseInfo(FullItemDialogGuiLayer gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                ITag tag = (ITag)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((ITag<Block>)tag);
                }
                return null;
            }

            @Override
            public void createControls(FullItemDialogGuiLayer gui, CreativeIngredient info) {
                GuiVBox test = new GuiVBox("test", 0, 30, Align.STRETCH);
                GuiComboBoxMapped<ITag<Block>> box = new GuiComboBoxMapped<ITag<Block>>("tag", 0, 30, new TextMapBuilder<ITag>().addComponents(BlockTags.func_199896_a().func_241833_a().values(), x -> new TextBuilder().stack(new ItemStack((IItemProvider)x.func_230236_b_().get(0))).text(BlockTags.func_199896_a().func_232973_a_(x).toString()).build()));
                test.add(box);
                test.add(new GuiTextfield("search", 0, 0, 10, 16));
                gui.add(test);
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(FullItemDialogGuiLayer gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BlockTags.func_199896_a().func_241833_a().values(), x -> new TextBuilder().stack(new ItemStack((IItemProvider)x.func_230236_b_().get(0))).text(BlockTags.func_199896_a().func_232973_a_(x).toString()).build()));
                }
            }
        });
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseInfo(FullItemDialogGuiLayer gui) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                ITag tag = (ITag)box.getSelected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((ITag<Item>)tag);
                }
                return null;
            }

            @Override
            public void createControls(FullItemDialogGuiLayer gui, CreativeIngredient info) {
                GuiVBox test = new GuiVBox("test", 0, 30, Align.STRETCH);
                GuiComboBoxMapped<ITag<Item>> box = new GuiComboBoxMapped<ITag<Item>>("tag", 0, 30, new TextMapBuilder<ITag>().addComponents(ItemTags.func_199903_a().func_241833_a().values(), x -> new TextBuilder().stack(new ItemStack((IItemProvider)x.func_230236_b_().get(0))).text(ItemTags.func_199903_a().func_232973_a_(x).toString()).build()));
                test.add(box);
                test.add(new GuiTextfield("search", 0, 0, 10, 16));
                gui.add(test);
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(FullItemDialogGuiLayer gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)gui.get("tag");
                    box.setLines(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(ItemTags.func_199903_a().func_241833_a().values(), x -> new TextBuilder().stack(new ItemStack((IItemProvider)x.func_230236_b_().get(0))).text(ItemTags.func_199903_a().func_232973_a_(x).toString()).build()));
                }
            }
        });
        GuiCreativeIngredientHandler.registerGuiInfoHandler("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseInfo(FullItemDialogGuiLayer gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(FullItemDialogGuiLayer gui, CreativeIngredient info) {
                gui.add(new GuiLabel("info", 5, 30).setTitle((ITextComponent)new StringTextComponent("Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }
}

